--
-- file prepared: 15 May 2024 23:17:57.106, using fd633c
--
--SFM_characteristics.lua (file 2 for assembly)

me262 = {

	Name = 'me262',

	DisplayName = _('me262'),
	ViewSettings = ViewSettings,
	Countries = { "Abkhazia","Australia","Austria","Belarus","Belgium","Brazil","Bulgaria","Canada","China",
			 "Croatia","Czech Republic","Denmark","Egypt","ESA","Finland","France","Georgia",
			 "German Empire","Germany","Greece","Hungary","Imperial Japan","India","Insurgents","Iran",
			 "Iraq","Israel","Italy","Japan","Kazakhstan","NASA","North Korea","Norway",
			 "Pakistan","Poland","Romania","Russia","Saudi Arabia","Serbia","Slovakia","South Korea",
			 "South Ossetia","Spain","Sweden","Switzerland","Syria","The Netherlands","Third Reich","Turkey","UK",
			 "Ukraine","USA","USAF Aggressors","USSR","Vietnam"},

	HumanCockpit = false,
	HumanCockpitPath = current_mod_path..'/Cockpit/',
	Picture = "me262.png",
	Rate = 50,
	Shape = "me262",

	shape_table_data =
	{
		{
			file = 'me262';
			life = 20;
			vis = 3;
			fire = { 300, 2};
			username = 'me262';
			index = WSTYPE_PLACEHOLDER;
		},
	},
	------------------------ -
	mapclasskey = "P0091000024",
	attribute = {wsType_Air, wsType_Airplane, wsType_Fighter, WSTYPE_PLACEHOLDER, "Multirole fighters", "Refuelable", "Datalink", "Link16"},
	Categories = {"{78EFB7A2-FD52-4b57-A6A6-3BF0E1D6555F}", "Interceptor",},

	---------	General	Characteristics	---------
	length = 10.6,
	height = 3.5,
	wing_area = 21.7,
	wing_span = 12.6,
	wing_tip_pos = { 0.75, 0.05, 6.5},
	RCS = 2.2,											-- (estimated from height, length and wing surface area)
	air_refuel_receptacle_pos = { 0, 0, 0},
	has_speedbrake = true,								-- default
	brakeshute_name = 4,								-- default
	is_tanker = false,									-- default
	tanker_type = 2,									-- default
	stores_number = 8,
	wing_type = 0,										-- default
	crew_size = 1,										-- default
	crew_size = 1,										-- default

	------- Weight & Fuel Characteristics -------
	M_empty = 3795,
	M_nominal = 6473,
	M_max = 7173,
	M_fuel_max = 1425,
	H_max = 11451,										-- (calculated from service_ceiling)
	CAS_min = 46,
	average_fuel_consumption = 1,						-- default

	----------_ AI Flight Parameters -----------
	V_opt = 177,
	V_take_off = 48,
	V_land = 48,
	V_max_sea_level = 111,
	V_max_h = 188,
	Vy_max = 20,
	Mach_max = 0.741,
	Ny_min = -3,										-- default
	Ny_max = 6,											-- default(wwii era, restricted maneuverability)
	Ny_max_e = 6,										-- default(wwii era, restricted maneuverability)
	AOA_take_off = 0.16,								-- default
	bank_angle_max = 60,								-- default
	range = 3000,										-- default
	flaps_maneuver = 1,									-- default

	-------- Suspension Characteristics -------
	and_gear_max = 1,									-- default
	nose_gear_pos = { 3.75, -1.75, 0},
	nose_gear_wheel_diameter = 0.5,						-- default
	nose_gear_amortizer_direct_stroke = 0.05,			-- default
	nose_gear_amortizer_reversal_stroke = -0.25,		-- default
	nose_gear_amortizer_normal_weight_stroke = -0.05,	-- default
	main_gear_pos = { 1, -1.75, 1.75},
	main_gear_wheel_diameter = 0.75,					-- default
	main_gear_amortizer_direct_stroke = 0.1,			-- default
	main_gear_amortizer_reversal_stroke = -0.275,		-- default
	main_gear_amortizer_normal_weight_stroke = -0.1,	-- default

	---------- Engine Characteristics ---------
	has_afteburner = false,
	thrust_sum_max = 1797.4,
	thrust_sum_ab = 1797.4,
	engines_count = 2,
	IR_emission_coeff = 0.05,							-- default
	IR_emission_coeff_ab = 0.05,						-- default

	--------- Sensors Characteristics ---------
	detection_range_max = 250,							-- default
	radar_can_see_ground = true,						-- default


---------------------------------------------------------------------------------------------------------------------------------------------

	crew_members =
	{
		[1] =
		{
			ejection_seat_name = 9,
			drop_canopy_name = "aircraft_canopy",
			canopy_pos = {3.75, -0.8, 0},
			canopy_ejection_dir = {0.0, 0.5, -0.5},
			pos = {3.75, -1.75, 0},
		}, --end of[1]
		--[2] =
		--{
			--ejection_seat_name = 9,
			--drop_canopy_name = "aircraft_canopy_2",
			--canopy_pos = {3.75, -0.8, 0},
			--canopy_ejection_dir = {0.0, 0.5, 0.5},
			--pos = {3.75, -1.75, 0},
			--canopy_arg = 421,
		--}, --end of[2]
	}, --end of crew_members

---------------------------------------------------------------------------------------------------------------------------------------------


	--------- Engine, nozzles and exhaust ---------

	engines_nozzles = {
		[1] =
		{
			pos = {-0.5, -0.8, 2.2},
			elevation = -0.8,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.225,
		}, -- end of [1]
		[2] =
		{
			pos = {-0.5, -0.8, -2.2},
			elevation = -0.8,
			diameter = 0.675,							-- default
			exhaust_length_ab = 3,						-- default
			exhaust_length_ab_K = 0.707,				-- default
			smokiness_level = 0.225,
		}, -- end of [2]
	}, -- end of engines_nozzles


---------------------------------------------------------------------------------------------------------------------------------------------


	Guns = {
		Mk108({ muzzle_pos = {4.05, 0.4, 0.55},_connector =  "Point_Gun_01",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		Mk108({ muzzle_pos = {4.15, 0.7, 0.25},_connector =  "Point_Gun_02",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		Mk108({ muzzle_pos = {4.15, 0.7, -0.25},_connector =  "Point_Gun_03",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
		Mk108({ muzzle_pos = {4.05, 0.4, -0.55},_connector =  "Point_Gun_04",rates = {1000},effect_arg_number = 350,mixes = {{1,2,3}},azimuth_initial = 0.0,elevation_initial = 0,supply_position = {0.0,0.0,0.0}}),
	},


	Pylons = {
		pylon(1, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon1", arg = 308, arg_value = 0,
			},
			{
			} 
		),
		pylon(2, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon2", arg = 309, arg_value = 0,
			},
			{
			} 
		),
		pylon(3, 0, 0.75, -0.33, 4.5, --
			{
				use_full_connector_position = true, connector = "Pylon3", arg = 310, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
			} 
		),
		pylon(4, 0, 1, -0.5, 3.5, --
			{
				use_full_connector_position = true, connector = "Pylon4", arg = 311, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
			} 
		),
		pylon(5, 0, 1, -0.5, -3.5, --
			{
				use_full_connector_position = true, connector = "Pylon5", arg = 312, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
				{ CLSID = "{BCE4E030-38E9-423E-98ED-24BE3DA87C32}" }, --MK-82 
			} 
		),
		pylon(6, 0, 0.75, -0.33, -4.5, --
			{
				use_full_connector_position = true, connector = "Pylon6", arg = 313, arg_value = 0,
			},
			{
				{ CLSID = "{90321C8E-7ED1-47D4-A160-E074D5ABD902}" }, --MK-81 
			} 
		),
		pylon(7, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon7", arg = 314, arg_value = 0,
			},
			{
			} 
		),
		pylon(8, 0, 0, 0, 0, --
			{
				use_full_connector_position = true, connector = "Pylon8", arg = 315, arg_value = 0,
			},
			{
			} 
		),
	},

---------------------------------------------------------------------------------------------------------------------------------------------

		 -- calibrate_countermeasures 

---------------------------------------------------------------------------------------------------------------------------------------------



	fires_pos =
	{
		[1] = { -0.125, 0.05, 0.0},
		[2] = { -0.05, 0.05, 0.25},
		[3] = { -0.075, 0.05, -0.25},
		[4] = { 1, 0.05, 1.625},
		[5] = { 1, 0.05, -1.625},
		[6] = { 1, 0.05, 5.2},
		[7] = { 1, 0.05, -5.2},
		[8] = { -0.5, -0.8, 0.25},
		[9] = { -0.5, -0.8, -0.25},
		[10] = { -0.25, 0.05, 0.25},
		[11] = { -0.25, 0.05, -0.25},
	},	-- end of fires_pos

---------------------------------------------------------------------------------------------------------------------------------------------


--(file 3 for aessembly)

	--[[
	fires_pos =
	{
		[1] = 	{-1.594,	-0.064,		0},
		[2] = 	{-1.073,	0.319,		2.304},
		[3] = 	{-1.187,	0.338,		-4.678},
		[4] = 	{-0.82,		0.265,		2.774},
		[5] = 	{-0.82,		0.265,		-2.774},
		[6] = 	{-0.82,		0.255,		4.274},
		[7] = 	{-0.82,		0.255,		-4.274},
		[8] = 	{-5.889,	-0.257,		1.193},
		[9] = 	{-5.889,	-0.257,		-1.193},
		[10] = 	{-1.257,	0.283,		3.05},
		[11] = 	{-1.257,	0.283,		-3.05},
	}, -- end of fires_pos
	]]--

	--[[

	-- Countermeasures
	passivCounterm = {
		CMDS_Edit = true,
		SingleChargeTotal = 128,
		-- PPR-26
		chaff = {default = 64, increment = 3, chargeSz = 1},
		-- PPI-26
		flare = {default = 64, increment = 3, chargeSz = 1}
	},
	]]--

	attribute 		= { wsType_Air, wsType_Airplane, wsType_Fighter, Su_34,"Bombers", "Refuelable"},
	CanopyGeometry	=  makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),
	
	--[[
	Sensors =
	{
		RADAR = "N-011M",
		OPTIC = "Su-34 FLIR",
		RWR   = "Abstract RWR"
	},
	]]--

	Tasks =
	{
		aircraft_task(AFAC),
		aircraft_task(SEAD),
		aircraft_task(AntishipStrike),
		aircraft_task(CAS),
		aircraft_task(CAP),
		aircraft_task(Intercept),
		aircraft_task(PinpointStrike),
		aircraft_task(GroundAttack),
		aircraft_task(RunwayAttack),
	},
	DefaultTask = aircraft_task(CAP),

	--SFM_aerodynamics.lua (file 4 for assembly)

	SFM_Data = {
		aerodynamics = --Cx = Cx_0 + Cy ^ 2 * B2 + Cy ^ 4 * B4
		{

			Cy0 = 0,
			Mzalfa = 4.355,					-- default
			Mzalfadt = 0.8,					-- default
			kjx = 3,						-- default
			kjz = 0.00125,					-- default
			Czbe = -0.016,					-- default
			cx_gear = 0.02,					-- default
			cx_flap = 0.08,					-- default
			cy_flap = 0.25,					-- default
			cx_brk = 0.1,					-- default

			table_data = {
				--M     Cx0     Cya     B       B4      Omxmax  Aldop   Cymax
				{0,		0.015,	0.0843,	0.058,	0.0151,	2.67,	13.6,	1.14,		},
				{0.1,	0.015,	0.0762,	0.058,	0.0151,	7.25,	15,	1.14,		},
				{0.2,	0.015,	0.081,	0.058,	0.0151,	7.25,	16.6,	1.34,		},
				{0.3,	0.015,	0.0871,	0.058,	0.0151,	7.25,	18.3,	1.55,		},
				{0.4,	0.015,	0.0932,	0.058,	0.0151,	7.25,	20.3,	1.92,		},
				{0.5,	0.015,	0.0891,	0.0372,	0.0106,	7.25,	20.3,	1.84,		},
				{0.6,	0.015,	0.0836,	0.026,	0.00842,	7.25,	20.3,	1.73,		},
				{0.7,	0.015,	0.0775,	0.0188,	0.00708,	7.25,	20.3,	1.6,		},
				{0.8,	0.0213,	0.0715,	0.00725,	0.0032,	2.67,	20.3,	1.48,		},
				{0.9,	0.0575,	0.03,	0.00145,	0.00019,	2.33,	20.3,	1.09,		},
				{1,		0.0675,	0.03,	0.409,	0.204,	2.04,	19.3,	1.03,		},
				{1.1,	0.0775,	0.03,	0.358,	0.179,	1.79,	18.3,	0.982,		},
			}, --end of table_data
		}, --end of aerodynamics
		engine = 
		{
			Nmg = 50,					-- default
			MinRUD = 0,
			MaxRUD = 1,
			MaksRUD  = 1,
			ForsRUD  = 1,
			typeng  = 0,
			hMaxEng	= 19,				-- default
			dcx_eng = 0.015,			-- default
			cemax  = 1.24,				-- default
			cefor  = 2.56,				-- default
			dpdh_m = 1000,
			dpdh_f = 2000,

			--[[			table_data = {
				--M 	Pmax	Pafb
				{0,	8528,	8528,		},
				{0.2,	12793,	12793,		},
				{0.4,	17057,	17057,		},
				{0.6,	17057,	17057,		},
				{0.8,	17057,	17057,		},
				{1,	17057,	17057,		},
				{1.2,	17057,	17057,		},
				{1.4,	17057,	17057,		},
				{1.6,	17057,	17057,		},
				{1.8,	17057,	17057,		},
				{2,	12793,	12793,		},
				{2.2,	8528,	8528,		},
			}, --end of table_data
			--]]

			table_data = {
				--M 	Pmax	Pafb
				{0.0,	0.0,	0.0,		},
				{ 2.0,	0.0,	0.0,		},
			}, --end of table_data


			--[[
				engine calibration worksheet (for in-game testing)
				alt     	vel		adj
				0 k ft		0.m		adj:+/-
				15 k ft		0.m		adj:+/-
				32 k ft		0.m		adj:+/-
				33 k ft		0.m		adj:+/-
				35 k ft		0.m		adj:+/-
				38 k ft		0.m		adj:+/-
				41 k ft		0.m		adj:+/-
				43 k ft		0.m		adj:+/-
			]]--

			extended = {

				thrust_max = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 9753, 10241, 10753, 11627, 12661, 13242 }, 
					thrust = {
						{ 17622,  26433,  35244,  35244,  35244,  35244,  35244,  35244,  35244,  35244,  26433,  17622  }, 
						{ 8539,   12809,  17079,  17079,  17079,  17079,  17079,  17079,  17079,  17079,  12809,  8539   }, 
						{ 3635,   5453,   7270,   7270,   7270,   7270,   7270,   7270,   7270,   7270,   5453,   3635   }, 
						{ 3156,   4734,   6312,   6312,   6312,   6312,   6312,   6312,   6312,   6312,   4734,   3156   }, 
						{ 3524,   5286,   7048,   7048,   7048,   7048,   7048,   7048,   7048,   7048,   5286,   3524   }, 
						{ 3524,   5286,   7048,   7048,   7048,   7048,   7048,   7048,   7048,   7048,   5286,   3524   }, 
						{ 2643,   3964,   5286,   5286,   5286,   5286,   5286,   5286,   5286,   5286,   3964,   2643   }, 
						{ 440,    660,    881,    881,    881,    881,    881,    881,    881,    881,    660,    440    }, 
					}, -- thrust = {

				}, --thrust_max = {

				thrust_afterburner  = {
					M = { 0.000000, 0.200000, 0.400000, 0.600000, 0.800000, 1.000000, 1.200000, 1.400000, 1.600000, 1.800000, 2.000000, 2.200000, }, 
					H = { 0, 4571, 9753, 10241, 10753, 11627, 12661, 13242 }, 
					thrust = {
						{ 17622,  26433,  35244,  35244,  35244,  35244,  35244,  35244,  35244,  35244,  26433,  17622  }, 
						{ 8539,   12809,  17079,  17079,  17079,  17079,  17079,  17079,  17079,  17079,  12809,  8539   }, 
						{ 3635,   5453,   7270,   7270,   7270,   7270,   7270,   7270,   7270,   7270,   5453,   3635   }, 
						{ 3156,   4734,   6312,   6312,   6312,   6312,   6312,   6312,   6312,   6312,   4734,   3156   }, 
						{ 3524,   5286,   7048,   7048,   7048,   7048,   7048,   7048,   7048,   7048,   5286,   3524   }, 
						{ 3524,   5286,   7048,   7048,   7048,   7048,   7048,   7048,   7048,   7048,   5286,   3524   }, 
						{ 2643,   3964,   5286,   5286,   5286,   5286,   5286,   5286,   5286,   5286,   3964,   2643   }, 
						{ 440,    660,    881,    881,    881,    881,    881,    881,    881,    881,    660,    440    }, 
					}, -- thrust = {

				}, --thrust_afterburner = {

			}, -- extended = {

		}, --end of engine

	},

	DamageParts =
	{
		[1] = "me262-collision",
	},

	-- (file 5 for aessembly)

	-- new
	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {
		[0]		= {critical_damage = 5, args = {146}},
		[3]		= {critical_damage = 20,args = {65}}  ,
		[4]		= {critical_damage = 20, args = {150}},
		[5]		= {critical_damage = 20, args = {147}},
		[7]		= {critical_damage = 4, args = {249}} ,
		[9]		= {critical_damage = 3, args = {154}},
		[10]	= {critical_damage = 3, args = {153}},
		[11]	= {critical_damage = 3, args = {167}},
		[12]	= {critical_damage = 3, args = {161}},
		[15]	= {critical_damage = 5, args = {267}},
		[16]	= {critical_damage = 5, args = {266}},
		[23]	= {critical_damage = 8, args = {223}, deps_cells = {25}},
		[24]	= {critical_damage = 8, args = {213}, deps_cells = {26, 60}},
		[25]	= {critical_damage = 3, args = {226}},
		[26]	= {critical_damage = 3, args = {216}},
		[29]	= {critical_damage = 9, args = {224}, deps_cells = {31, 25, 23}},
		[30]	= {critical_damage = 9, args = {214}, deps_cells = {32, 26, 24, 60}},
		[31]	= {critical_damage = 4, args = {229}},
		[32]	= {critical_damage = 4, args = {219}},
		[35]	= {critical_damage = 10, args = {225}, deps_cells = {29, 31, 25, 23}},
		[36]	= {critical_damage = 10, args = {215}, deps_cells = {30, 32, 26, 24, 60}} ,
		[37]	= {critical_damage = 4, args = {227}},
		[38]	= {critical_damage = 4, args = {217}},
		[39]	= {critical_damage = 7,	args = {244}, deps_cells = {53}},
		[40]	= {critical_damage = 7, args = {241}, deps_cells = {54}},
		[45]	= {critical_damage = 9, args = {235}, deps_cells = {39, 51, 53}},
		[46]	= {critical_damage = 9, args = {233}, deps_cells = {40, 52, 54}},
		[51]	= {critical_damage = 3, args = {239}},
		[52]	= {critical_damage = 3, args = {237}},
		[53]	= {critical_damage = 3, args = {248}},
		[54]	= {critical_damage = 3, args = {247}},
		[55]	= {critical_damage = 20, args = {81}, deps_cells = {39, 40, 45, 46, 51, 52, 53, 54}},
		[59]	= {critical_damage = 5, args = {148}},
		[60]	= {critical_damage = 1, args = {144}},

		[83]	= {critical_damage = 3, args = {134}} ,-- nose wheel
		[84]	= {critical_damage = 3, args = {136}}, -- left wheel
		[85]	= {critical_damage = 3, args = {135}} ,-- right wheel
	},


	-- solve triangle to have B_end == C_end with given A
	-- B_start assumed to be A_start
	-- C_start assumed to be A_end
	
	SolveTriangles = 
	{
		-- left gear post kinematics 
		{
			A_start   = "bracing_centr004",
			A_end     = "bracing_centr003",
			B_end     = "bracing_004",
			B_control = 484,
			C_end	  = "bracing_003",
			C_control = 483,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
		-- right gear post kinematics 
		{
			A_start   = "bracing_centr006",
			A_end     = "bracing_centr005",
			B_end     = "bracing_006",
			B_control = 486,
			C_end	  = "bracing_005",
			C_control = 485,
			B_scale   =  1/math.rad(46);
			C_scale   =  1/math.rad(25);
		},
	},  --SolveTriangles


}



--SFM_add.lua (file 6 for assembly)

add_aircraft(me262)


